<?php
session_start();

if (isset($_SESSION['ranking']) && isset($_SESSION['loc']) && isset($_SESSION['cell']) && isset($_SESSION['skortopsis'])) {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="results.csv"');

    $output = fopen("php://output", "w");
    // Write the column headers
    fputcsv($output, ['Ranking', 'Alternatif', 'Skor', 'Link Lokasi']);

    foreach ($_SESSION['ranking'] as $index => $rank) {
        $locationLink = $_SESSION['loc'][($index + 2)];
        if (!preg_match("~^(?:f|ht)tps?://~i", $locationLink)) {
            $locationLink = "http://" . $locationLink;
        }
        $row = [
            $rank,
            $_SESSION['cell'][($index + 2)][1],
            $_SESSION['skortopsis'][$index],
            $locationLink,
        ];
        fputcsv($output, $row);
    }

    fclose($output);
    exit();
}
?>
